import React, { useState } from "react";
import { Modal } from "react-native";
import ImageViewer from "react-native-image-zoom-viewer";
import PhotoGalleryStyle from "./CustomPhotoGallery.style";
import RenderFooter from "./RenderFooter";
import RenderHeader from "./RenderHeader";

const CustomPhotoGallery = ({
    isOpen,
    setIsOpen,
    images,
    index,
    setCurrentSlideIndex,
}) => {
    const newImages = images.map((item) => {
        return {
            url: item,
        };
    });
    const photoGalleryStyle = PhotoGalleryStyle();
    const [updateIndex, setUpdateIndex] = useState(index);

    return (
        <Modal visible={isOpen} style={photoGalleryStyle.modalCont}>
            <ImageViewer
                imageUrls={newImages}
                index={updateIndex}
                renderHeader={() => (
                    <RenderHeader
                        setIsOpen={setIsOpen}
                        updateIndex={updateIndex}
                        setCurrentSlideIndex={setCurrentSlideIndex}
                    />
                )}
                renderFooter={(image) => (
                    <RenderFooter
                        images={newImages}
                        image={image}
                        setUpdateIndex={setUpdateIndex}
                    />
                )}
                onCancel={() => setIsOpen(false)}
                enableSwipeDown={false}
                swipeDownThreshold={0.6}
                renderIndicator={() => null}
            />
        </Modal>
    );
};

export default CustomPhotoGallery;
